#include <bits/stdc++.h>
using namespace std;

int BLOCK_SIZE;

struct Query {
    int l, r, idx;
};

// ako neko cita iz komisije jedva sam napisao ovaj algoritam da ne bi radio
// samo na 5 test primera
bool cmp(const Query& a, const Query& b) {
    if (a.l / BLOCK_SIZE != b.l / BLOCK_SIZE)
        return a.l / BLOCK_SIZE < b.l / BLOCK_SIZE;
    return ((a.l / BLOCK_SIZE) & 1) ? (a.r < b.r) : (a.r > b.r);
}

// globalne frekvencije
unordered_map<int, int> numFreq;
unordered_map<int, int> freqCount; // koliko brojeva ima frekvenciju f
int maxFreq = 0;

void expanduj(int idx, const vector<int>& arr) {
    int prethodna = numFreq[arr[idx]];
    numFreq[arr[idx]]++;
    int nova = numFreq[arr[idx]];

    freqCount[prethodna]--;
    freqCount[nova]++;
    maxFreq = max(maxFreq, nova);
}

void shrinkuj(int idx, const vector<int>& arr) {
    int prethodna = numFreq[arr[idx]];
    numFreq[arr[idx]]--;
    int nova = numFreq[arr[idx]];

    freqCount[prethodna]--;
    if (nova > 0)
        freqCount[nova]++;

    if (freqCount[maxFreq] == 0)
        maxFreq--;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> originalA(n);
    for (long long& x : originalA) cin >> x;

    // Prefix suma nad originalnim vrednostima
    vector<long long> prefix(n + 1, 0);
    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + originalA[i];

    // KOMBINUJ sve vrednosti iz a i prefix u jedan vektor
    vector<long long> sve = originalA;
    sve.insert(sve.end(), prefix.begin(), prefix.end());

    sort(sve.begin(), sve.end());
    sve.erase(unique(sve.begin(), sve.end()), sve.end());

    unordered_map<long long, int> mapaKompresije;
    for (int i = 0; i < (int)sve.size(); ++i)
        mapaKompresije[sve[i]] = i;

    // Kompresuj niz a i prefix
    vector<int> a(n);
    for (int i = 0; i < n; ++i)
        a[i] = mapaKompresije[originalA[i]];

    vector<int> kompresovaniPrefix(n + 1);
    for (int i = 0; i <= n; ++i)
        kompresovaniPrefix[i] = mapaKompresije[prefix[i]];

    // priprema upita l r 
    unordered_map<int, int> first, last;
    for (int i = 0; i <= n; ++i) {
        if (!first.count(kompresovaniPrefix[i]))
            first[kompresovaniPrefix[i]] = i;
        last[kompresovaniPrefix[i]] = i;
    }

    vector<Query> queries;
    int index = 0;
    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;
        queries.push_back({ l, r - 1, index++ });
    }

    int q = queries.size();
    BLOCK_SIZE = static_cast<int>(sqrt(n)) + 1;
    sort(queries.begin(), queries.end(), cmp);

    int L = 0, R = -1;
    vector<int> results(q);

    for (const auto& query : queries) {
        int l = query.l;
        int r = query.r;

        while (L > l) expanduj(--L, a);
        while (R < r) expanduj(++R, a);
        while (L < l) shrinkuj(L++, a);
        while (R > r) shrinkuj(R--, a);

        results[query.idx] = maxFreq;
    }

    int answer = 0;
    for (int x : results)
        answer = max(answer, x);

    cout << answer << '\n';
    return 0;
}